﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Newtonsoft.Json;
using Ext.Net;
using System.IO;
using System.Data;
using DataAccess;
using System.Collections;
using System.Web.Script.Serialization;
using System.Xml;

//setup an alias for all direct method calls on this control
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "UCEVENTADDINSTRUMENT")]

public partial class ucEventAddInstrument : System.Web.UI.UserControl
{
    public BaseMaster BaseMstr { get; set; }

    /// <summary>
    /// US:7356 patient pathway event id
    /// </summary>
    public string PatPWEventID
    {
        get
        {
            string strValue = "";
            if (Session["UCEVTADDINTSR_PATPWEVENTID"] != null)
            {
                strValue = Session["UCEVTADDINTSR_PATPWEVENTID"].ToString();
            }

            return strValue;
        }
        set { Session["UCEVTADDINTSR_PATPWEVENTID"] = Convert.ToString(value); }
    }

    /// <summary>
    /// US:7356 page load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    /// <summary>
    /// US:7356 get comma delimeted list of instruments already added to this event
    /// </summary>
    /// <returns></returns>
    protected string GetEventMIDS()
    {
        CCPA cpa = new CCPA();

        //get all modules already added to this event and not completed
        string strEventMIDS = ",";
        DataSet dsEventMID = cpa.GetPWEventModuleDS(BaseMstr, CDataUtils2.ToLong(PatPWEventID));
        if (dsEventMID != null)
        {
            foreach (DataTable tbl in dsEventMID.Tables)
            {
                foreach (DataRow rw in tbl.Rows)
                {
                    if (CDataUtils2.GetDSLongValue(rw, "INTAKE_ID") < 1) //not completed
                    {
                        strEventMIDS += CDataUtils2.GetDSStringValue(rw, "MID");
                        strEventMIDS += ",";
                    }
                }
            }
        }

        return strEventMIDS;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7272 US:7356  user searched for instruments
    /// </summary>
    public void OnSearch()
    {
        string strSearch = tfEITSearch.Text;
        //if (strSearch.Length < 3)
        //{
        //    BaseMstr.ShowSystemFeedback("Search must be at least 3 characters!", "Search Error");
        //    return;
        //}


        DataSet dsMID = null;
        
        if(rdoEITCPA.Checked || rdoEITDisp.Checked)
        {
            string strGroupID = cboEventInstrumentGroup.SelectedItem.Value;

            CIntake intake = new CIntake();
            dsMID = intake.GetModuleGroupMIDDS(BaseMstr, 
                                               Convert.ToInt64(strGroupID), 
                                               strSearch);
        }
        else
        {

            CCPA cpa = new CCPA();
            dsMID = cpa.GetModuleSearchDS(BaseMstr,
                                          strSearch);
        }

        if (CDataUtils2.IsEmpty(dsMID))
        {
            BaseMstr.ShowSystemFeedback("No matches found!", "Search Error");
            return;
        }

        //get all modules already added to this event
        string strEventMIDS = GetEventMIDS();

        foreach (DataTable table in dsMID.Tables)
        {
            foreach (DataRow row in table.Rows)
            {
                string strMIDCheck = "," + CDataUtils2.GetDSStringValue(row, "MID") + ",";
                if (strEventMIDS.IndexOf(strMIDCheck) > -1)
                {
                    //remove mids that are already part of the event
                    row.Delete();
                }
                else
                {
                    //module data is not encoded in the db...
                    row["MODULE"] = HttpUtility.HtmlEncode(row["MODULE"].ToString());
                    row["DESCRIPTION"] = HttpUtility.HtmlEncode(row["DESCRIPTION"].ToString());
                    row["MODULE_ALT_LANG"] = HttpUtility.HtmlEncode(row["MODULE_ALT_LANG"].ToString());
                }
            }
        }
        dsMID.AcceptChanges();

        //clear the store
        storEventInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //load the store from the ds
        CDataConverter cdc = new CDataConverter();
        storEventInstruments.SetDataFromJson(cdc.GetJsonDSString(dsMID));
    }

    /// <summary>
    /// US:7356 load instruments gridpanel by group id
    /// </summary>
    protected void LoadInstruments(string strGroupID)
    {   
        //get the modules ds
        CIntake im = new CIntake();
        DataSet dsMID = im.GetModuleGroupMIDDS(BaseMstr, CDataUtils2.ToLong(strGroupID));

        //get all modules already added to this event
        string strEventMIDS = GetEventMIDS();

        if (CDataUtils2.IsEmpty(dsMID))
        {
            return;
        }
        foreach (DataTable table in dsMID.Tables)
        {
            foreach (DataRow row in table.Rows)
            {
                string strMIDCheck = "," + CDataUtils2.GetDSStringValue(row, "MID") + ",";
                if (strEventMIDS.IndexOf(strMIDCheck) > -1)
                {
                    //remove mids that are already part of the event
                    row.Delete();
                }
                else
                {
                    //module data is not encoded in the db...
                    row["MODULE"] = HttpUtility.HtmlEncode(row["MODULE"].ToString());
                    row["DESCRIPTION"] = HttpUtility.HtmlEncode(row["DESCRIPTION"].ToString());
                    row["MODULE_ALT_LANG"] = HttpUtility.HtmlEncode(row["MODULE_ALT_LANG"].ToString());
                }
            }
        }
        dsMID.AcceptChanges();

        //clear the store
        storEventInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //load the store from the ds
        CDataConverter cdc = new CDataConverter();
        storEventInstruments.SetDataFromJson(cdc.GetJsonDSString(dsMID));
    }


    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7356 fires when a group is selected from the combo
    /// </summary>
    public void OnGroupSelect()
    {
        //clear the store
        storEventInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());
        if (cboEventInstrumentGroup.SelectedItem == null)
        {
            return;
        }

        //get the group id from the combo
        string strGroupID = cboEventInstrumentGroup.SelectedItem.Value;

        //enable search
        EnableSearch();

        //load the instruments for this group
        LoadInstruments(strGroupID);
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7356  load the instrument grid based on the combo group type
    /// </summary>
    /// <param name="strGroupTypeID"></param>
    public void OnGroupTypeSelect()
    {
        //clear the instruments
        gpEventInstruments.GetStore().RemoveAll();
        storEventInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());
        
        if(rdoEITCPA.Checked)
        {
            DisableSearch();
            cboEventInstrumentGroup.Show();
            this.LoadInstrumentGroups(1000);
        }
        else if(rdoEITDisp.Checked)
        {
            DisableSearch();
            cboEventInstrumentGroup.Show();
            this.LoadInstrumentGroups(2000);
        }
        else
        {
            if (rdoEITAll.Checked == false)
            {
                rdoEITAll.Checked = true;
            }

            EnableSearch();
            //this.LoadInstrumentGroups(-1);
            
            //clear value
            cboEventInstrumentGroup.SetValue(null);
            //clear the store
            storEventModuleGroups.SetDataFromJson(CDataUtils2.GetEmptyJSON());
            cboEventInstrumentGroup.Hide();

            //now just load all the modules
            CCPA cpa = new CCPA();
            DataSet dsMID = cpa.GetAllModuleDS( BaseMstr);

            //get all modules already added to this event
            string strEventMIDS = GetEventMIDS();

            foreach (DataTable table in dsMID.Tables)
            {
                foreach (DataRow row in table.Rows)
                {
                    string strMIDCheck = "," + CDataUtils2.GetDSStringValue(row, "MID") + ",";
                    if (strEventMIDS.IndexOf(strMIDCheck) > -1)
                    {
                        //remove mids that are already part of the event
                        row.Delete();
                    }
                    else
                    {
                        //module data is not encoded in the db...
                        row["MODULE"] = HttpUtility.HtmlEncode(row["MODULE"].ToString());
                        row["DESCRIPTION"] = HttpUtility.HtmlEncode(row["DESCRIPTION"].ToString());
                        row["MODULE_ALT_LANG"] = HttpUtility.HtmlEncode(row["MODULE_ALT_LANG"].ToString());
                    }
                }
            }
            dsMID.AcceptChanges();

            //clear the store
            storEventInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

            //load the store from the ds
            CDataConverter cdc = new CDataConverter();
            storEventInstruments.SetDataFromJson(cdc.GetJsonDSString(dsMID));

        }
    }

    /// <summary>
    /// US: 7356 Disable Search controls
    /// </summary>
    private void DisableSearch()
    {
        tfEITSearch.Clear();
        tfEITSearch.ClearInvalid();
        tfEITSearch.Disabled = true;
        btnAddInstrumentSearch.Disabled = true;
    }

    /// <summary>
    /// US: 7356 Enable Search controls
    /// </summary>
    private void EnableSearch()
    {
        tfEITSearch.Disabled = false;
        btnAddInstrumentSearch.Disabled = false;
    }

    /// <summary>
    ///US:7356 load instrument groups into the combo
    /// </summary>
    /// <param name="lGroupTypeID"></param>
    public void LoadInstrumentGroups(long lGroupTypeID)
    {
        //clear value
        cboEventInstrumentGroup.SetValue(null);

        //clear the store
        storEventModuleGroups.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //get the group types ds
        CIntake im = new CIntake();
        DataSet dsModuleGroup = im.GetModuleGroupDS(BaseMstr, lGroupTypeID);
        if (CDataUtils2.IsEmpty(dsModuleGroup))
        {
            return;
        }

        //load the store from the ds
        CDataConverter cdc = new CDataConverter();
        storEventModuleGroups.SetDataFromJson(cdc.GetJsonDSString(dsModuleGroup));
    }

    /// <summary>
    /// US:7356 show the intrument add popup
    /// </summary>
    public void Show()
    {  
        //default to ALL 
        rdoEITCPA.Checked = false;   //1000 = Clinical Program Area
        rdoEITDisp.Checked = false; //2000 = Disiplines
        rdoEITAll.Checked = true;  //-1 = All
        
        //load the combo with cpa options
        this.LoadInstrumentGroups(1000);

        //clear the combo selection
        cboEventInstrumentGroup.ClearValue();

        //clear the instruments
        gpEventInstruments.GetStore().RemoveAll();
        storEventInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //show the window
        wndEventAddInstrument.Show();

        //start with ALL instruments loaded
        OnGroupTypeSelect();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7356 ok button handler for instrument add popup
    /// </summary>
    protected void OnInstrSelOK(object sender, DirectEventArgs e)
    {
        //JSON representation
        string gpJSON = e.ExtraParams["gpSelParam"];
        gpJSON = HttpUtility.HtmlDecode(gpJSON);
        
        //XML representation
        XmlNode gpXml = JSON.DeserializeXmlNode("{records:{record:" + gpJSON + "}}");

        //array of Dictionaries
        Dictionary<string, string>[] gpData = JSON.Deserialize<Dictionary<string, string>[]>(gpJSON);

        //get mid and module_for values
        string strFors = String.Empty;
        string strMids = String.Empty;
        for (int i = 0; i < gpData.Count(); i++)
        {
            strFors += gpData[i]["MODULE_FOR"];
            if (i != gpData.Count() - 1)
            {
                strFors += ",";
            }

            strMids += gpData[i]["MID"];
            if (i != gpData.Count() - 1)
            {
                strMids += ",";
            }
        }

        //update event info and the list of modules. 
        //this will remove all current modules and replace with 
        //only the selected modules...
        CCPA cpa = new CCPA();
        cpa.InsertPatPWEventModules(BaseMstr,
                                    BaseMstr.SelectedPatientID,
                                    CDataUtils2.ToLong(PatPWEventID),
                                    strMids,
                                    strFors);


        //close the add instrument popup
        wndEventAddInstrument.Close();
    }
    

}